﻿var INT_DISP = 1;
var HEX_DISP = 2;

var PmtPidInt = new Array(2048);
var PmtPidHex = new Array(2048);
var PcrPidInt = new Array(2048);
var PcrPidHex = new Array(2048);
var TotPidInt = new Array(2048);
var TotPidHex = new Array(2048);

var NUM_COLUMNS = 14;
var g_RowCount = 1; // row number after which the new is to be inserted. should be incremented
var g_OffSet = 0;

var columnName = new Array("streamType","sendMode","srcIPAddr","srcUDPPort","destIPAddr","destUDPPort","sync",
						   "progType","inpProgNo","inpPmtPid","inpPcrPid","esPid","bitRate","replicated");
var colWidth = new Array("55px","50px","50px","100px","50px","100px","50px","50px","50px","75px","45px","45px","45px","60px","70px");
var DB_MPTS  = "MPTS";
var DB_DATA  = "Data";

var card_index;//a
var gbe_index;//b
var global_gbe_index;//a/b

var arg_UDP = 0;

var language;

function DelRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		table.deleteRow(g_RowCount);
		g_RowCount--; // row number after which the new is to be inserted. should be incremented
	}
}

function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCount + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCount++;
	}
}

function UpdateRowNum(tableId, dataLen)
{
	g_OffSet = g_RowCount;
	AddRows(tableId, (dataLen - 1));
}

function UpdateRowData(table, rowID, rowData)
{
	var index = 0;
	var row = rowID + g_OffSet;
	UpdatePidArrays((row - 2), rowData);// populates Int n Hex PID arrays

	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var textData = "";
		
		var cell = table.rows[row].cells[i];
		cell.style.width = colWidth[i];
		/*if(i == 13) // Replications
		{
			cell.innerHTML = "";
			var el = document.createElement("input");
	    	el.type = "button";
	    	el.id = ("B" + columnName[i] + (row));
	    	el.value = rowData[i];
//			el.onclick = MM_openReplicPopUp;
			cell.appendChild(el);
    	}
    	else if((i == 8) && (rowData[0] == DB_MPTS))//stream type is MPTS
		{
			cell.innerHTML = "";
			var el = document.createElement("input");
	    	el.type = "button";
	    	el.id = ("B" + columnName[i] + (row));
	    	el.value = "Details";
//			el.onclick = MM_openBrWindow;
			cell.appendChild(el);
    	}
		else
		{*/
			/*if(i == 2)
			{
				textData = global_gbe_index;
			}
			else*/
		    if(i == 12)
			{
				textData = parseFloat(rowData[i]).toFixed(4);
			}
			else
			{
				textData = rowData[i];
			}
			cell.innerHTML = textData;
		//}
	}
}

function UpdateTableData(tableId, inpResp)
{
	var dataLen = inpResp.length;
	var MeasRow;
	var table = document.getElementById(tableId);
	for(var i = 0; i < (dataLen - 1); i++)
	{
		MeasRow = inpResp[i];
		var rowData = MeasRow.split(",");
		UpdateRowData(table, (i + 1), rowData);
	}
}

function PaintMeasTable(MeasTable)
{
	var dataLen = MeasTable.length;//the end is row value, then dataLen is n+1
	UpdateRowNum("MeasGbeTable", dataLen);
	UpdateTableData("MeasGbeTable", MeasTable);
	return true;
}

function getElementId(Event)
{
    var elementId;
    if(window.event)
    {
       elementId = window.event.srcElement.id;
    }
    else
    {
        elementId = Event.target.id;
    }
    return elementId;
}

function MM_openBrWindow(Event)
{
	var table = document.getElementById("MeasGbeTable");
	var elemId = getElementId(Event);
	var len = elemId.length;
	elemId = elemId.substring(10, len);
	var UDPId = 3;
	var GbeId = 1;
	var DestId = 2;
	arg_UDP = table.rows[elemId].cells[UDPId].innerHTML;
	arg_UDP = arg_UDP + "&" + table.rows[elemId].cells[GbeId].innerHTML;
	arg_UDP = arg_UDP + "&" + table.rows[elemId].cells[DestId].innerHTML;
	theURL = "mpts_details.html?" + arg_UDP;
	winName = "Replications";
	features = "width=900,height=520,status,scrollbars,resizable=1";
	window.open(theURL, winName, features, resizable = 1);
	window.open(theURL, winName, features);
}

function MM_openReplicPopUp(Event)
{
	var table = document.getElementById("MeasGbeTable");
	var elemId = getElementId(Event);
	var len = elemId.length;
	elemId = elemId.substring(11, len);

	var UDPId = 3;
	var GbeId = 1;
	var DestId = 2;
	arg_UDP = table.rows[elemId].cells[GbeId].innerHTML;
	arg_UDP = arg_UDP + "&" + table.rows[elemId].cells[UDPId].innerHTML;
	arg_UDP = arg_UDP + "&" + table.rows[elemId].cells[DestId].innerHTML;

	theURL = "stream_reps.html?" + arg_UDP;
	winName = "";
	features = "width=950,height=550,status,scrollbars,resizable=1";
	window.open(theURL, winName, features);
}


function TriggerPidsDisp(dispType,tableId)
{
	var table = document.getElementById(tableId);

	if(dispType == HEX_DISP)
	{
		for(var i = 0; i < (g_RowCount - 1); i++)
		{
			table.rows[i + 2].cells[9].innerHTML = PmtPidHex[i];
			table.rows[i + 2].cells[10].innerHTML = PcrPidHex[i];
			table.rows[i + 2].cells[11].innerHTML = TotPidHex[i];
		}
	}
	else if(dispType == INT_DISP)
	{
		for(var i = 0; i < (g_RowCount - 1); i++)
		{
			table.rows[i + 2].cells[9].innerHTML = PmtPidInt[i];
			table.rows[i + 2].cells[10].innerHTML = PcrPidInt[i];
			table.rows[i + 2].cells[11].innerHTML = TotPidInt[i];
		}
	}
}

function TogglePidsHexDisp()
{
	var dispType = 0;
	if((document.getElementById("HexDisplay")).checked)
	{
		dispType = HEX_DISP;
	}
	else
	{
		dispType = INT_DISP;
	}
	TriggerPidsDisp(dispType,"MeasGbeTable");
}

function UpdatePidArrays(rowIndex,rowData)
{
    var temp;
	if(rowData[9] == "N/A")
	{
		PmtPidInt[rowIndex] = "N/A";
		PmtPidHex[rowIndex] = "N/A";
	}
	else
	{
		PmtPidInt[rowIndex] = rowData[9];
		
		temp = parseInt(rowData[9]);
		PmtPidHex[rowIndex] = "0x" + temp.toString(16);
	}
	if(rowData[10] == "N/A")
	{
		PcrPidInt[rowIndex] = "N/A";
		PcrPidHex[rowIndex] = "N/A";
	}
	else
	{
		PcrPidInt[rowIndex] = rowData[10];

		temp = parseInt(rowData[10]);
		PcrPidHex[rowIndex] = "0x" + temp.toString(16);
	}
	if(rowData[11] == "N/A")
	{
		TotPidInt[rowIndex] = "N/A";
		TotPidHex[rowIndex] = "N/A";
	}
	else
	{
		TotPidInt[rowIndex] = rowData[11];
		temp = parseInt(rowData[11]);
		TotPidHex[rowIndex] = "0x" + temp.toString(16);
	}
}

var start_chn;
var row_index;
var init_row = true;
function GetMeasureGbeInpData()
{
	var Response;
	var xmlhttp = getHTTPObject();
	
	if(init_row)
	{
		row_index = 0;
		start_chn = "1/1.1";
	}
	
	var getParam = "type=11&cmd=1" + "&gbe_port=" + global_gbe_index + "&start_chn=" + start_chn + "&row_index=" + row_index + "&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParam.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				Response = gb2utf8(xmlhttp.responseBody);
				var index = Response.indexOf("</html>");
				var bias = Response.length - index;
				Response = Response.slice(7, - bias);
			}
			else
			{
				Response = xmlhttp.responseText.slice(7, -8);
			}
			var inpResp = Response.split("&");
			var inpLen = inpResp.length;
			PaintMeasTable(inpResp);

			init_row = false;
			
			if(inpResp[inpLen - 1].indexOf("start_chn") != -1)
			{
				var cur_row_string = inpResp[inpLen - 1].split(",");
				start_chn = cur_row_string[1]; //The element before-last in response array stores the value of "start_chn"
				row_index = cur_row_string[3];
			}

			if(inpResp[inpLen - 1] == "end")
			{
				init_row = true;
				return true;
			}
			setTimeout("GetMeasureGbeInpData()", 5);
		}//if
	}
	xmlhttp.send(getParam);
}

window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	gbe_index = parseInt(str[2]);

	global_gbe_index = card_index + "/" + gbe_index;
	language = document.getElementById("language").value;
	GetMeasureGbeInpData();
}
